require( "HiddenObject/script/style.lua" );
SimonButtonFont = {
  standardFont,
  24,
  SimonTextColor
};

SimonGraphics_Pause = {
	"Simon/UI/pausenormal",
	"Simon/UI/pausemousedown",
	"Simon/UI/pausemouseover"
};


SimonStyle_Pause = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ButtonGraphics_Pause,
};

SimonGraphics_Skip = {
	"Simon/UI/skipnormal",
	"Simon/UI/skipmousedown",
	"Simon/UI/skipmouseover"
};

SimonGraphics_Hint = {
	"Simon/UI/HintBox"
};

SimonStyle_Skip = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = SimonGraphics_Hint,
};

FooterMenuGraphics = {
	"Simon/UI/oknormal",
	"Simon/UI/okmousedown",
	"Simon/UI/okmouseover"
};


FooterMenuStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterMenuGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}


MakeDialog
{
	-- Name the modal dialog
	name="SimonWindow",
	Bitmap
	{
		name="SimonsWindowBackgroundImage",
		image="Simon/UI/background",
		x = 0,
		y = 0,
		w = 800,
		h = 600,			
			
		SimonWindow
		{
			x=0,
			y=0,
			w=800,
			h=600,
	
			SetStyle(SimonStyle_Pause);	
			Button
			{
				x=420,
				y=545,
				font = SimonButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				graphics = SimonGraphics_Pause,
				name="pause",
				label="pause",
				type = kPush,
				command=
					function()
					if IsWindowActive() then
						SendGameMessage("unpause");
						SendGameMessage("pause");
						--DoModal("HiddenObject/script/pause.lua");
					end
					end
			},
			
			SetStyle(SimonStyle_Skip);
			Button
			{
				x=650,
				y=545,
				font = SimonButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				graphics = SimonGraphics_Skip,
				name="skip",
				label="skip",
				type = kPush,
				command=
					function()
					if IsWindowActive() then
						--EnableWindow( "pause", false);
						--EnableWindow( "skip", false);
						--DoModal("HiddenObject/script/skip.lua");
						SendGameMessage('activateSkip');
					  end
					end
			},
			
			Button
			{
				x=513,
				y=537,
				name="simonhint",
				label="simonhint",
				font = SimonButtonFont,
				graphics = SimonGraphics_Hint,
			},
			
						
			SetStyle(FooterMenuStyle);
			Button
			{
				x=253,
				y=325,
				font = FooterMenuButtonFont,
				graphics = FooterMenuGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="statistics_ok",
				label="ok",
				type = kPush,
				command=
					function()
						EnableWindow( "statistics_ok", false);
						if (GetInstanceCount() <= 2) then
							SendGameMessage("ok");
						else
							DoModal('Simon/Script/retrydialog.lua');

						end		
					end
			},
		},
	
	},
}


EnableWindow( "statistics_ok", false);
EnableWindow( "pause", false);
EnableWindow( "skip", false);
EnableWindow( "simonhint", false);
SetFocus( "SimonWindow" );	